#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;


uniform mat4 worldViewProj;
uniform int transitionState;
uniform float transitionProgress=1.0;

out vec2 fsTexture;
out vec2 fsVertex;
out float mix1;
out float mix2;

void main()
{
    mat4 projection = mat4(
                           2.4140,0.0000,0.0000,0.0000,
                           0.0000,2.4140,0.0000,0.0000,
                           0.0000,0.0000,-1.020,-.4870,
                           0.0000,0.0000,-1.000,0.0000);
    mat4 translation=mat4(
                          1.0, 0.0, 0.0, 0.00,
                          0.0, 1.0, 0.0, 0.00,
                          0.0, 0.0, 1.0,-2.42,
                          0.0, 0.0, 0.0, 1.00);
	fsTexture = vsTexture;
    fsVertex=vsPosition.xy;
    mix2=1.;
    if(transitionState==0)
    {
        mix1=0.0;
        mix2=0.0;
    }
    else if(transitionState==2)
    {
        mix1=1.0;
        mix2=0.0;
    }

    vec4 worldPos=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0)*worldViewProj;
    worldPos*=translation;
	gl_Position = worldPos*projection;
}
