#version 330

uniform sampler2DRect inputTex;
uniform float transitionProgress=1.0;
uniform float transitionAlpha=1.0;
uniform int transitionState;
uniform float baseAlpha=1.0;

in vec2 fsTexture;
in vec2 fsVertex;
in float mix1;
in float mix2;
out vec4 outColor;

void main()
{
    float dist=length(fsVertex)*.7;

    float inAlpha=transitionProgress-dist;
    inAlpha*=20.;
    inAlpha=min(inAlpha,1.0);
    inAlpha=max(inAlpha,0.0);
    
    float outAlpha=dist-transitionProgress;
    outAlpha+=.05;
    outAlpha*=20.;
    outAlpha=min(outAlpha,1.0);
    outAlpha=max(outAlpha,0.0);
    
    float alpha=mix(inAlpha,outAlpha,mix1);
    
    alpha=mix(alpha,1.,mix2);
    
    outColor = texture(inputTex, fsTexture)*alpha*baseAlpha;
}


