#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;


uniform mat4 worldViewProj;
uniform int transitionState;
uniform float transitionProgress=1.0;

out vec2 fsTexture;

void main()
{
    vec4 deltaTrans=vec4(2.,2.,8.,.0);
    vec4 transOffset=vec4(1.,1.,4.0,.0);
    
    mat4 projection = mat4(
                           2.4140,0.0000,0.0000,0.0000,
                           0.0000,2.4140,0.0000,0.0000,
                           0.0000,0.0000,-1.020,-.4870,
                           0.0000,0.0000,-1.000,0.0000);
    mat4 translation=mat4(
                          1.0, 0.0, 0.0, 0.00,
                          0.0, 1.0, 0.0, 0.00,
                          0.0, 0.0, 1.0,-2.41,
                          0.0, 0.0, 0.0, 1.00);
    
    vec4 tmpPos=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0)*worldViewProj;
    vec4 worldPos=tmpPos;
    
    float progress=.5;
    if(transitionState==0)
        progress=transitionProgress*.5;
    else if(transitionState==2)
        progress=transitionProgress*.5+.5;
    
    transOffset-=deltaTrans*progress;
    
    translation[0][3]+=transOffset.x;
    translation[1][3]+=transOffset.y;
    translation[2][3]+=transOffset.z;
    
    worldPos*=translation;
	gl_Position = worldPos*projection;
    
	fsTexture = vsTexture;
}
