#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;


uniform mat4 worldViewProj;
uniform int transitionState;
uniform float transitionProgress=1.0;

out vec2 fsTexture;

void main()
{
    vec4 transOffset=vec4(0.,-1.,4.0,.0);
    
    float stimer=0.;
    if(transitionState==0)
        stimer=3.1415926535897932384626433832795+transitionProgress*3.1415926535897932384626433832795;
    else if(transitionState==2)
        stimer=transitionProgress*3.1415926535897932384626433832795;
    
    mat4 rotation = mat4(
                         cos(stimer),  0.0,-sin(stimer), 0.0,
                         0.0,  1.0,        0.0, 0.0,
                         sin(stimer),  0.0, cos(stimer), 0.0,
                         0.0,  0.0,        0.0, 1.0);
    mat4 projection = mat4(
                           2.4140,0.0000,0.0000,0.0000,
                           0.0000,2.4140,0.0000,0.0000,
                           0.0000,0.0000,-1.020,-.4870,
                           0.0000,0.0000,-1.000,0.0000);
    mat4 translation=mat4(
                          1.0, 0.0, 0.0, 0.00,
                          0.0, 1.0, 0.0, 0.00,
                          0.0, 0.0, 1.0,-2.41,
                          0.0, 0.0, 0.0, 1.00);
    
    vec4 tmpPos=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0)*worldViewProj;
    
    vec4 worldPos=tmpPos*rotation;
    worldPos*=translation;
	gl_Position = worldPos*projection;
    
	fsTexture = vsTexture;
}
