#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;

uniform mat4 worldViewProj;
uniform float transitionProgress=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;
uniform int transitionState;

out vec2 fsTexture;
out float fsAlpha;
out float fsMix;

void main()
{
    gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0)*worldViewProj;
    fsAlpha=max(0.0,transitionAlpha*2.0-1.0);
    if(transitionState==0)
        fsMix=0.0;
    else
        fsMix=1.0;
    
	fsTexture = vsTexture;
}
