#version 330

uniform sampler2DRect inputTex;
uniform float transitionProgress=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;

in vec2 fsTexture;
in float fsAlpha;
in float fsMix;
out vec4 outColor;

void main()
{
    vec4 texColor=texture(inputTex, fsTexture);
    vec4 color1=texColor*fsAlpha*baseAlpha;
    vec4 color2=texColor;
    color2.rgb=mix(vec3(0.0),texColor.rgb*baseAlpha,fsAlpha);
    
    outColor=mix(color1,color2,fsMix);
//    outColor = texture(inputTex, fsTexture)*fsAlpha*baseAlpha;
}


