#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;

uniform sampler2DRect inputTex;
uniform mat4 worldViewProj;
uniform int transitionState;
uniform float transitionProgress=1.0;

out vec2 fsTexture;
out float texWidth;


void main()
{
    vec4 deltaTransIn=vec4(0.,0.,-3.0,.0);
    vec4 transOffsetIn=vec4(0.0,0.0,-3.0,.0);

    mat4 projection = mat4(
                           2.4140,0.0000,0.0000,0.0000,
                           0.0000,2.4140,0.0000,0.0000,
                           0.0000,0.0000,-1.020,-.4870,
                           0.0000,0.0000,-1.000,0.0000);
    mat4 translation=mat4(
                          1.0, 0.0, 0.0, 0.00,
                          0.0, 1.0, 0.0, 0.00,
                          0.0, 0.0, 1.0,-2.41,
                          0.0, 0.0, 0.0, 1.00);

    vec4 worldPos=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0)*worldViewProj;

    if(transitionState==0)
    {
        float progress=transitionProgress*1.;
        transOffsetIn-=deltaTransIn*progress;
        
        translation[0][3]+=transOffsetIn.x;
        translation[1][3]+=transOffsetIn.y;
        translation[2][3]+=transOffsetIn.z;
    }

    worldPos*=translation;
	gl_Position = worldPos*projection;

    
    
	fsTexture = vsTexture;
    
    ivec2 texSize=textureSize(inputTex);
    texWidth=float(texSize.x);
}
