#version 330

uniform sampler2DRect inputTex;
uniform float transitionProgress=1.0;
uniform float transitionAlpha=1.0;
uniform int transitionState;
uniform float baseAlpha=1.0;

in vec2 fsTexture;
in float texWidth;
out vec4 outColor;

void main()
{
    outColor=vec4(0,0,0,0);
    if(transitionState==0)
    {
//        vec2 tadj=fsTexture;
//        float open=transitionProgress*.5;
//        float middle=texWidth*.5;
//        if(fsTexture.x>middle)
//        {
//            tadj.x=fsTexture.x-(open*texWidth);
//            if(tadj.x>middle)
//                discard;
//        }
//        else
//        {
//            tadj.x=fsTexture.x+(open*texWidth);
//            if(tadj.x<middle)
//                discard;
//        }
        outColor=texture(inputTex,fsTexture)*baseAlpha;
    }
    else
    {
        //expanding old texture and splitting in middle
        vec2 tadj=fsTexture;
        float open=transitionProgress*.5;
        float middle=texWidth*.5;
        if(fsTexture.x>middle)
        {
            tadj.x=fsTexture.x-(open*texWidth);
            if(tadj.x<middle)
                discard;
        }
        else
        {
            tadj.x=fsTexture.x+(open*texWidth);
            if(tadj.x>middle)
                discard;
        }
        outColor=texture(inputTex,tadj)*baseAlpha;
    }
}

