#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;

uniform mat4 worldViewProj;
uniform int transitionState;
uniform float transitionAlpha=1.0;

out vec2 fsTexture;
out vec2 fsTexture2;

void main()
{
    gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0)*worldViewProj;
    
    fsTexture = vsTexture;

    ivec2 texSize=textureSize(inputTex);
    vec2 tmp=fsTexture/vec2(texSize);
    texSize=textureSize(inputTex1);
    fsTexture2=vec2(texSize)*tmp;
}
