#version 330

uniform sampler2DRect inputTex0;
uniform sampler2DRect inputTex1;
uniform sampler2DRect inputTex2;
uniform float uyScale;
uniform float cosHue;
uniform float sinHue;
uniform float contrast;
uniform float saturation;
uniform float brightness;


const vec4 std709R = vec4( 1.793,1.164383, 0.000000,0.0  );
const vec4 std709G = vec4(-0.534,1.164383,-0.213,0.0  );
const vec4 std709B = vec4( 0.000000,1.164383, 2.115,0.0  );
const vec4 stdbias = vec4(-0.5  , -0.0625,  -0.5   ,0.0  );

in vec2 fsTexY;
in vec2 fsTexUV;
out vec4 outColor;

void main()
{
    vec4 yuvIn;
    vec4 yuvOut;

	yuvIn.a=0.0;
    yuvIn.g = texture(inputTex0, fsTexY).r;
    yuvIn.b = texture(inputTex1, fsTexUV).r;
    yuvIn.r = texture(inputTex2, fsTexUV).r;
    
    yuvIn+=stdbias;
    
    outColor=vec4(dot(std709R, yuvIn),
                  dot(std709G, yuvIn),
                  dot(std709B, yuvIn),
                  1.0 );
}
