#version 330

uniform sampler2DRect inputTex0;
uniform sampler2DRect inputTex1;
uniform sampler2DRect inputTex2;
uniform float uyScale;
uniform float cosHue;
uniform float sinHue;
uniform float contrast;
uniform float saturation;
uniform float brightness;

//const vec4 std601R = vec4(  1.164 ,  0.0  ,  1.4022,0.0  );
//const vec4 std601G = vec4(  1.164 , -0.391, -0.813 ,0.0  );
//const vec4 std601B = vec4(  1.164 ,  2.018,  0.0   ,0.0  );
//const vec4 stdbias = vec4( -0.0625, -0.5  , -0.5   ,0.0  );

const vec4 std601R = vec4( 1.596027,1.164383, 0.000000,0.0  );
const vec4 std601G = vec4(-0.812968,1.164383,-0.391762,0.0  );
const vec4 std601B = vec4( 0.000000,1.164383, 2.017232,0.0  );
const vec4 stdbias = vec4(-0.5  , -0.0625,  -0.5   ,0.0  );

//const vec4 test[4] = vec4[]( vec4(0,0,0,0), vec4(1,1,1,1) );

uniform vec4 selector[4] = vec4[]  (
    vec4(0.0, 0.0, 1.0, 0.0),
    vec4(0.0, 1.0, 0.0, 0.0),
    vec4(1.0, 0.0, 0.0, 0.0),
    vec4(0.0, 0.0, 0.0, 1.0)
    );

in vec2 fsTexture;
out vec4 outColor;

void main()
{
    vec4 yGroup;
    vec4 uGroup;
    vec4 vGroup;
    vec4 yuvIn;
    vec4 yuvOut;
    vec2 inTex=fsTexture;
    
    int index;
    
    inTex.x*=.25;
	index = int(floor(fract(inTex.x) * 4.0));

    yGroup = texture(inputTex0, inTex);
    
    inTex.x*=.5;
    inTex.y*=uyScale;

    uGroup = texture(inputTex1, inTex);
    vGroup = texture(inputTex2, inTex);

//    if(index==0)
//    {
//        yuvIn.g=yGroup.b;
//    }
//    else if(index==1)
//    {
//        yuvIn.g=yGroup.g;
//    }
//    else if(index==2)
//    {
//        yuvIn.g=yGroup.r;
//    }
//    else
//    {
//        yuvIn.g=yGroup.a;
//    }

//    yuvIn.g=dot(selector[index],yGroup);
    switch(index)
    {
    case 0:
        yuvIn.g=yGroup.b;
        break;
    case 1:
        yuvIn.g=yGroup.g;
        break;
    case 2:
        yuvIn.g=yGroup.r;
        break;
    case 3:
        yuvIn.g=yGroup.a;
        break;
    }

	index = int(floor(fract(inTex.x) * 4.0));
    
//    if(index==0)
//    {
//        yuvIn.b=uGroup.b;
//        yuvIn.r=vGroup.b;
//    }
//    else if(index==1)
//    {
//        yuvIn.b=uGroup.g;
//        yuvIn.r=vGroup.g;
//    }
//    else if(index==2)
//    {
//        yuvIn.b=uGroup.r;
//        yuvIn.r=vGroup.r;
//    }
//    else
//    {
//        yuvIn.b=uGroup.a;
//        yuvIn.r=vGroup.a;
//    }

//    yuvIn.b=dot(selector[index],uGroup);
//    yuvIn.r=dot(selector[index],vGroup);
    switch(index)
    {
    case 0:
        yuvIn.b=uGroup.b;
        yuvIn.r=vGroup.b;
        break;
    case 1:
        yuvIn.b=uGroup.g;
        yuvIn.r=vGroup.g;
        break;
    case 2:
        yuvIn.b=uGroup.r;
        yuvIn.r=vGroup.r;
        break;
    case 3:
        yuvIn.b=uGroup.a;
        yuvIn.r=vGroup.a;
        break;
    }

    yuvIn+=stdbias;
//    yuvOut.g = (yuvIn.g * contrast) + brightness;
//    float tmp=contrast*saturation;
//    yuvOut.r = (yuvIn.r * cosHue + yuvIn.b * sinHue) * tmp;
//    yuvOut.b = (yuvIn.b * cosHue - yuvIn.r * sinHue) * tmp;
//    yuvOut.a=yuvIn.a;

    outColor=vec4(dot(std601R, yuvIn),
                  dot(std601G, yuvIn),
                  dot(std601B, yuvIn),
                  1.0 );
}
