#version 330

uniform  sampler2DRect inputTex;

//const vec4 std709R = vec4(  1.164 ,  0.0  ,  1.4022,0.0  );
//const vec4 std709G = vec4(  1.164 , -0.391, -0.813 ,0.0  );
//const vec4 std709B = vec4(  1.164 ,  2.018,  0.0   ,0.0  );
//const vec4 stdbias = vec4( -0.0625, -0.5  , -0.5   ,0.0  );

const vec4 std709R = vec4( 1.793,1.164383, 0.000000,0.0  );
const vec4 std709G = vec4(-0.534,1.164383,-0.213,0.0  );
const vec4 std709B = vec4( 0.000000,1.164383, 2.115,0.0  );
const vec4 stdbias = vec4(-0.5  , -0.0625,  -0.5   ,0.0  );




in vec2 fsTexture;
in vec2 fsSampleTexture;
out vec4 outColor;

void main()
{
    //outColor=texture(inputTex, fsSampleTexture);

    vec4 y0;
    vec4 y1;

    float isOddUV;
    
	isOddUV = floor(fract(fsTexture.x * 0.5) * 2.0);

    y0 = texture(inputTex, fsSampleTexture);
    y1=y0;
    y1.g=y0.a;
	y0=mix(y0,y1,isOddUV);
    
    y0+=stdbias;
    
    outColor=vec4(dot(std709R, y0),
                  dot(std709G, y0),
                  dot(std709B, y0),
                  1.0 );
}
