//
// Fragment shader for vignette photo effect
//
// Author: Jeff Brown
//
//


#version 330

uniform sampler2DRect inputTex;

in float fsOuterRadius;
in float fsInnerRadius;
in vec2 fsTexture;
in vec3 fsPosition;
out vec4 outColor;

void main()
{
    vec4 texel = texture(inputTex, fsTexture);
    float dist=distance(fsPosition,vec3(0.0,0.0,0.0));
    float darken=clamp((fsOuterRadius-dist)/(fsOuterRadius-fsInnerRadius),0.0,1.0);
    outColor.rgb=texel.rgb*darken;
    outColor.a=texel.a;
}
