//

// Fragment shader for sepia effect
//
// Author: Shirley Carter
// updated to 330 and rvfx system by Jeff Brown
//


#version 330

uniform sampler2DRect inputTex;
uniform float uTransitionProgress=1.0;

in vec2 fsTexture;
out vec4 outColor;

void main()
{
	vec4 texel = texture(inputTex, fsTexture);
	// Convert to grayscale using NTSC conversion weights
    float gray = dot(texel.rgb, vec3(0.299, 0.587, 0.114));
    
    // convert grayscale to sepia
    outColor = vec4(gray * vec3(1.2, 1.0, 0.8), texel.a);
}
