#version 330

uniform sampler2DRect inputTex;

layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
uniform float radius;

out vec2 fsTexture;
out float drawingWidth;
out float drawingHeight;

void main()
{
	gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0);

    ivec2 textureSize2d = textureSize(inputTex);
    fsTexture = vsTexture;
    drawingHeight=float(textureSize2d.x);
    drawingWidth=float(textureSize2d.y);
}