//

// Fragment shader for sepia effect
//
// Author: Shirley Carter
//
// map grayscale to heat signature
// updated to 330 and rvfx system by Jeff Brown
//


#version 330

uniform sampler2DRect inputTex;
uniform float uTransitionProgress=1.0;

in vec2 fsTexture;
out vec4 outColor;

void main()
{
	
	vec4 color = texture(inputTex, fsTexture);
	
	// Convert to grayscale using NTSC conversion weights
	
    float gray = dot(color.rgb, vec3(0.299, 0.587, 0.114));

	// compute the heat signature value
	
	vec4 heatSig = vec4( 0.0, 0.0, 0.0, 0.0 );
	
	if ( gray < 0.25 )
	{
		// black to blue
		gray *= 4.0;

		heatSig.r = 0.0;
		heatSig.g = 0.0;
		heatSig.b = gray;
	}
	else if ( gray < 0.5 )
	{
		// blue to green
		gray -= 0.25;
		gray *= 4.0;

		heatSig.r = 0.0;
		heatSig.g = gray;
		heatSig.b = 1.0 - gray;
	}
	else if ( gray < 0.75 )
	{
		// green to yellow
		gray -= 0.5;
		gray *= 4.0;

		heatSig.r = gray;
		heatSig.g = 1.0;
		heatSig.b = 0.0;
	}
	else
	{
		// yellow to red
		gray -= 0.75;
		gray *= 4.0;

		heatSig.r = 1.0;
		heatSig.g = 1.0 - gray;
		heatSig.b = 0.0;
	}
	
	heatSig.a = color.a;
	
	outColor = heatSig;
}

