//

// Fragment shader for sepia effect
//
// Author: Shirley Carter
//
// invert like a B&W negative
// updated to 330 and rvfx system by Jeff Brown
//


#version 330

uniform sampler2DRect inputTex;
uniform float uTransitionProgress=1.0;

in vec2 fsTexture;
out vec4 outColor;

void main(void)
{
	
	vec4 texel = texture(inputTex, fsTexture);

    // Convert to grayscale
    float gray = dot(texel.rgb, vec3(0.299, 0.587, 0.114));

    // invert
    gray = 1.0 - gray;

    // replicate grayscale to RGB components
    outColor = vec4(gray, gray, gray, texel.a);
}

