#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;

uniform float uPass=0.0;
uniform float blurAmount;

out vec2 fsTexCoords[15];
out vec2 fsTexNormalized;

void main()
{
    float fsScale;
	gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0);
    
    fsScale=blurAmount*3.0;
    if(fsScale==0.0)
        fsScale=0.1;
    
    vec2 horizontalDir=vec2(fsScale+fsScale*.5,0.0);
    vec2 verticalDir=vec2(0.0,fsScale+fsScale*.5);
    float pass=uPass;
    if(pass>1.0)
        pass-=2.0;
    vec2 direction=mix(horizontalDir,verticalDir,pass);
    vec2 dsTexture=vsTexture;
    
    fsTexCoords[ 0] = dsTexture + vec2(-7.0,-7.0)*direction;
    fsTexCoords[ 1] = dsTexture + vec2(-6.0,-6.0)*direction;
    fsTexCoords[ 2] = dsTexture + vec2(-5.0,-5.0)*direction;
    fsTexCoords[ 3] = dsTexture + vec2(-4.0,-4.0)*direction;
    fsTexCoords[ 4] = dsTexture + vec2(-3.0,-3.0)*direction;
    fsTexCoords[ 5] = dsTexture + vec2(-2.0,-2.0)*direction;
    fsTexCoords[ 6] = dsTexture + vec2(-1.0,-1.0)*direction;
    fsTexCoords[ 7] = dsTexture + vec2( 1.0, 1.0)*direction;
    fsTexCoords[ 8] = dsTexture + vec2( 2.0, 2.0)*direction;
    fsTexCoords[ 9] = dsTexture + vec2( 3.0, 3.0)*direction;
    fsTexCoords[10] = dsTexture + vec2( 4.0, 4.0)*direction;
    fsTexCoords[11] = dsTexture + vec2( 5.0, 5.0)*direction;
    fsTexCoords[12] = dsTexture + vec2( 6.0, 6.0)*direction;
    fsTexCoords[13] = dsTexture + vec2( 7.0, 7.0)*direction;
    fsTexCoords[14] = dsTexture;

    fsTexNormalized=(vsPosition.xy+vec2(1.0,1.0))*vec2(.5,.5);
}