#version 330

uniform sampler2DRect inputTex;

const vec4 std601R = vec4( 1.596027,1.164383, 0.000000,0.0  );
const vec4 std601G = vec4(-0.812968,1.164383,-0.391762,0.0  );
const vec4 std601B = vec4( 0.000000,1.164383, 2.017232,0.0  );
const vec4 stdbias = vec4(-0.5  , -0.0625,  -0.5   ,0.0  );

in vec2 fsTexture;
out vec4 outColor;

void main()
{
	float isOddLine;
	vec2 tc00;
	vec2 tc10;
	vec2 tc20;
	vec4 c00;
	vec4 c10;
	vec4 c20;
	vec4 avg;
    
	tc10=fsTexture.xy;
    
	isOddLine=1.0-floor(fract(tc10.y * 0.5) * 2.0);
    
	//above and below lines start with same coordinates
    tc00=tc10;
	tc20=tc10;
	//for above line, subtract 1
	tc00.y-=isOddLine;
	//for below line, add 1
	tc20.y+=isOddLine;
    
	c00 = texture(inputTex, tc00);
//	c10 = texture(inputTex, tc10);
	c20 = texture(inputTex, tc20);
  
#if 1
	avg=(c00+c20)*0.5;
    outColor=avg;
#else
	avg=(c00+c20)*0.5;
    float g0=dot(c00.rgb, vec3(0.299, 0.587, 0.114));
    float g1=dot(c10.rgb, vec3(0.299, 0.587, 0.114));
    float g2=dot(c20.rgb, vec3(0.299, 0.587, 0.114));
    
    if(g1>=g0)
    {
        if(g1>g2)
            c10=avg;
    }
    else
    {
        if(g1<g2)
            c10=avg;
    }
    outColor=c10;
#endif
}
