#version 330

uniform sampler2DRect inputTex0;
uniform sampler2DRect inputTex1;
uniform sampler2DRect inputTex2;
uniform float cosHue;
uniform float sinHue;
uniform float contrast;
uniform float saturation;
uniform float brightness;

const vec4 std709R = vec4( 1.793,1.164383, 0.000000,0.0  );
const vec4 std709G = vec4(-0.534,1.164383,-0.213,0.0  );
const vec4 std709B = vec4( 0.000000,1.164383, 2.115,0.0  );
const vec4 stdbias = vec4(-0.5  , -0.0625,  -0.5   ,0.0  );
const vec4 scale10to16 = vec4(64.0, 64.0, 64.0, 0.0);


uniform float vScale;
uniform float hScale;


in vec2 fsTexY;
in vec2 fsTexUV;
out vec4 outColor;

void main()
{
	float isOddLine;
    vec4 yuv0;
    vec4 yuv1;
    vec4 yuv2;
    vec4 avg;
	vec2 tc00;
	vec2 tc10;
	vec2 tc20;

	tc10=fsTexY;
    
	isOddLine=1.0-floor(fract(tc10.y * 0.5) * 2.0);

	//above and below lines start with same coordinates
    tc00=tc10;
	tc20=tc10;
	//for above line, subtract 1
	tc00.y-=isOddLine;
	//for below line, add 1
	tc20.y+=isOddLine;
    
    
	yuv0.g = texture(inputTex0, tc00).r;
	yuv1.g = texture(inputTex0, tc10).r;
	yuv2.g = texture(inputTex0, tc20).r;

    tc00*=vec2(hScale,vScale);
    tc10*=vec2(hScale,vScale);
    tc20*=vec2(hScale,vScale);

    yuv0.b = texture(inputTex1, tc00).r;
	yuv1.b = texture(inputTex1, tc10).r;
	yuv2.b = texture(inputTex1, tc20).r;

    yuv0.r = texture(inputTex2, tc00).r;
	yuv1.r = texture(inputTex2, tc10).r;
	yuv2.r = texture(inputTex2, tc20).r;
    
	avg=(yuv0+yuv2)*0.5;
    
    if(yuv1.g>=yuv0.g)
    {
        if(yuv1.g>yuv2.g)
            yuv1=avg;
    }
    else
    {
        if(yuv1.g<yuv2.g)
            yuv1=avg;
    }

    yuv1.a=0.0;
    yuv1*=scale10to16;
    yuv1+=stdbias;

    outColor=vec4(dot(std709R, yuv1),
                  dot(std709G, yuv1),
                  dot(std709B, yuv1),
                  1.0 );
}
