#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;

uniform vec4 pickedColor;

out vec2 fsTexture;
out float pickedHue;

vec3 RGBtoHSVWrong( float r, float g, float b )
{
    float minf, maxf, delta;
    vec3 hsv;
    
    minf = min(min( r, g), b);
    maxf = max(max( r, g), b);
    hsv.z = maxf; 				// v
    
    delta = maxf - minf;
    
    if( abs(maxf) > 0.0 ) {
        hsv.y = delta/maxf;    		// s
        
        
    }
    else {
        // r = g = b = 0		// s = 0, v is undefined
        hsv.y = 0.0;  // *s = 0;
        hsv.x = -1.0;  //*h = -1;
    }
    
    if( abs(r-maxf)<0.0001)
        hsv.x = ( g - b ) / delta;		// between yellow & magenta
    else if( abs(g-maxf)<0.0001 )
        hsv.x = 2.0 + ( b - r ) / delta;	// between cyan & yellow
    else
        hsv.x = 4.0 + ( r - g ) / delta;	// between magenta & cyan
    
    hsv.x = hsv.x*60.0;			  	// degrees
    if( hsv.x < 0.0 )
        hsv.x = hsv.x+ 360.0;
    
    return hsv;
}

void main()
{
    vec3 tmp=RGBtoHSVWrong(pickedColor.r,pickedColor.g,pickedColor.b);
    pickedHue=tmp.r;
    
	gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0);
	fsTexture = vsTexture;
}
