//
// adjust HSCB
//

#version 330

const vec4 std601X = vec4(  0.299 ,  0.587,  0.114, 0.0  );
const vec4 std601Y = vec4( -0.169 , -0.331,  0.500, 0.0  );
const vec4 std601Z = vec4(  0.500 , -0.419, -0.081, 0.0  );

const vec4 std601R = vec4( 1.596027*0.85882394366802,1.164383*0.85882394366802, 0.000000,0.0  );
const vec4 std601G = vec4(-0.812968*0.85882394366802,1.164383*0.85882394366802,-0.391762*0.85882394366802,0.0  );
const vec4 std601B = vec4( 0.000000,1.164383*0.85882394366802, 2.017232*0.85882394366802,0.0  );
const vec4 stdbias = vec4(-0.5  , -0.0625,  -0.5   ,0.0  );

uniform sampler2DRect inputTex;

uniform float contrast;
uniform float brightness;
uniform float saturation;

in vec2 fsTexture;
in float fsCosHue;
in float fsSinHue;

out vec4 outColor;

void main(void)
{
	vec4 texColor;
	vec4 yuvIn;
    vec4 yuvOut;
    
    texColor = texture(inputTex, fsTexture);
    
	yuvIn = vec4(dot(std601X, texColor),
                 dot(std601Y, texColor),
                 dot(std601Z, texColor),
                 1.0 );
//	yuvIn = vec4(dot(std601X, texColor)+0.0425,
//                 dot(std601Y, texColor)+0.5,
//                 dot(std601Z, texColor)+0.5,
//                 1.0 );
    

//    yuvIn+=stdbias;
    yuvOut.g = (yuvIn.r * contrast) + brightness;
    float tmp=contrast*saturation;
    yuvOut.r = (yuvIn.b * fsCosHue + yuvIn.g * fsSinHue) * tmp;
    yuvOut.b = (yuvIn.g * fsCosHue - yuvIn.b * fsSinHue) * tmp;
    yuvOut.a=yuvIn.a;
    
    outColor=vec4(dot(std601R, yuvOut),
                  dot(std601G, yuvOut),
                  dot(std601B, yuvOut),
                  texColor.a);
}

