#version 330

#include "transitionHelperGL.h"
#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform float transitionProgress=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;
uniform sampler2DRect maskTex;
in vec2 fsMaskTexture;


in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsTextureSize;
in float fsMix;
out vec4 outColor;


vec4 grayscale (vec4 color)
{
    float gray=0.2126*color.r + 0.7152*color.g + 0.0722*color.b;
    return vec4(gray,gray,gray,color.a);
}

void main()
{
    vec4 texel1=getColor(inputTex,fsTexture);
    vec4 texel2=getColor(inputTex1,fsTexture2);

#ifndef PRE_MULT
    multiplyAlpha(texel1);
    multiplyAlpha(texel2);
#endif

    vec4 color1=mix(grayscale(texel1),texel1,smoothstep(.6,1.0,transitionProgress));
    vec4 color2=mix(grayscale(texel2),texel2,smoothstep(.6,1.0,1.0-transitionProgress));
    outColor=mix(color2,color1,transitionProgress);

#ifdef USE_MASK
    multiplyOpacityPremultiplied(outColor, texture(maskTex, fsMaskTexture).a);
#endif

#ifndef PRE_MULT
    divideAlpha(outColor);
#endif
}
