#include "metalShaderTypes.h"
#include "alpha.h"
#include "commonMLDX.h"
#include "outputColorHelper.h"

constexpr sampler nearestSampler(
    mip_filter::nearest,
    mag_filter::nearest,
    min_filter::nearest,
    address::clamp_to_border,
    border_color::transparent_black);



vertex vertexOut vertexFunc(uint vertexID [[ vertex_id ]],
                                   const device pixCopyVertexFormat* in [[ buffer(0) ]])
{
    vertexOut out;

    out.position = in[vertexID].pos;

    out.tex1 = in[vertexID].tc;

    return out;
}

fragment float4 fragmentFunc(vertexOut input [[stage_in]],
                             texture2d<half> inputTex0 [[ texture(0) ]])
{
    float2 texSize=float2(inputTex0.get_width(),inputTex0.get_height());

    float4 texColor0 = toOutput(float4(inputTex0.sample(nearestSampler,input.tex1/texSize)));
    float4 outColor=float4(texColor0.b,texColor0.g,texColor0.r,texColor0.a);
    return outColor;
}

