#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;
uniform float transitionProgress=1.0;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;
uniform vec4 burnColor;

in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsTextureSize;
in vec2 fsTextureSize2;
in vec2 fsMaskTexture;
in vec2 fsTextureNormalized;
in vec2 fsTextureNormalized2;


out vec4 outColor;

float rand (vec2 co)
{
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

float Gaussian(float p, float center, float c)
{
    return 0.575 * exp(- pow((p - center) / c, 2.));
}

#define PI 3.1415926535897932384626433832795
float cosCurve(float p)
{
    return 0.5 * (cos(2.0*PI * (p - 0.5)) + 1.0);
}

void main()
{
    vec2 p = fsTextureNormalized;
    vec2 p2 = fsTextureNormalized2;
    float c = cos(0.575 * cosCurve(transitionProgressLinear * (1. + cosCurve(transitionProgressLinear) * Gaussian(transitionProgressLinear * rand(p), 0.5, 0.5))));
    float c2 = cos(0.575 * cosCurve(transitionProgressLinear * (1. + cosCurve(transitionProgressLinear) * Gaussian(transitionProgressLinear * rand(p2), 0.5, 0.5))));
    vec2 d = p * c;
    vec2 d2 = p2 * c2;

    vec4 colorA=texture(inputTex,d*fsTextureSize);
    vec4 colorB=texture(inputTex1,d2*fsTextureSize2);
    mixColor(outColor, colorB, colorA, transitionProgressLinear);

#ifdef USE_MASK
    multiplyOpacity(outColor, texture(maskTex, fsMaskTexture).a);
#endif
}
