#version 330

#include "transitionHelperGL.h"
#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;
uniform float transitionProgress=1.0;
uniform float transitionAlpha=1.0;
uniform int transitionState;
uniform float baseAlpha=1.0;
in vec2 fsMaskTexture;


in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsVertex;
in vec2 fsTextureNormalized;
in float fsABSelect;
out vec4 outColor;

void main()
{
    float dist=length(fsTextureNormalized-vec2(.5,.5));

    float outAlpha=dist-transitionProgress;
    outAlpha+=.05;
    outAlpha*=20.;
    outAlpha=min(outAlpha,1.0);
    outAlpha=max(outAlpha,0.0);

    vec4 texColor = texture(inputTex, fsTexture);
    vec4 colorA = mix(vec4(0,0,0,0), texColor, fsABSelect);
    vec4 colorB = mix(texColor, vec4(0,0,0,0), fsABSelect);
    mixColor(outColor, colorA, colorB, outAlpha);

    float alpha = baseAlpha;
#ifdef USE_MASK
    alpha *= texture(maskTex, fsMaskTexture).a;
#endif
    multiplyOpacity(outColor, alpha);
}
