#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
layout (location=2) in vec2 vsTextureMask;

uniform sampler2DRect maskTex;
uniform vec2 windowSize;
out vec2 fsFragScale;


uniform mat4 worldViewProj;
uniform int transitionState;
uniform float transitionProgress=1.0;
uniform int direction=0;
uniform sampler2DRect inputTex;

out vec2 fsTexture;

const vec4 deltaTransTable[9] = vec4[]  (
                                         vec4(-2.,2.,8.,.0),
                                         vec4(0.,2.,8.,.0),
                                         vec4(2.,2.,8.,.0),
                                         vec4(-2.,0.,8.,.0),
                                         vec4(0.,0.,8.,.0),
                                         vec4(2.,0.,8.,.0),
                                         vec4(-2.,-2.,8.,.0),
                                         vec4(0.,-2.,8.,.0),
                                         vec4(2.,-2.,8.,.0)
                                         );

const vec4 transOffsetTable[9] = vec4[]  (
                                          vec4(-1.,1.,4.0,.0),
                                          vec4(0.,1.,4.0,.0),
                                          vec4(1.,1.,4.0,.0),
                                          vec4(-1.,0.,4.0,.0),
                                          vec4(0.,0.,4.0,.0),
                                          vec4(1.,0.,4.0,.0),
                                          vec4(-1.,-1.,4.0,.0),
                                          vec4(0.,-1.,4.0,.0),
                                          vec4(1.,-1.,4.0,.0)
                                          );


void main()
{
    vec4 deltaTrans=deltaTransTable[direction];
    vec4 transOffset=transOffsetTable[direction];

#if 1
#define near .50
#define far 200.0
    mat4 projection = mat4(
                           2.4140,0.0000,0.0000,0.0000,
                           0.0000,2.4140,0.0000,0.0000,
                           0.0000,0.0000,(far+near)/(near-far),(2*near*far)/(near-far),
                           0.0000,0.0000,-1.000,0.0000);
#else
    mat4 projection = mat4(
                           2.4140,0.0000,0.0000,0.0000,
                           0.0000,2.4140,0.0000,0.0000,
                           0.0000,0.0000,-1.020,-.4870,
                           0.0000,0.0000,-1.000,0.0000);
#endif
    mat4 translation=mat4(
                          1.0, 0.0, 0.0, 0.00,
                          0.0, 1.0, 0.0, 0.00,
                          0.0, 0.0, 1.0,-2.414,
                          0.0, 0.0, 0.0, 1.00);

    vec4 tmpPos=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0)*worldViewProj;
    vec4 worldPos=tmpPos;

    float progress=.5;
    if(transitionState==0)
        progress=transitionProgress*.5;
    else if(transitionState==2)
        progress=transitionProgress*.5+.5;

    transOffset-=deltaTrans*progress;

    translation[0][3]+=transOffset.x;
    translation[1][3]+=transOffset.y;
    translation[2][3]+=transOffset.z;

    worldPos*=translation;
    gl_Position = worldPos*projection;

    fsTexture=vsTexture*vec2(textureSize(inputTex));
    fsFragScale=vec2(textureSize(maskTex))/windowSize;
}
