#version 330


uniform sampler2DRect inputTex;

layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;

const vec2 s1 = vec2(-.5, .5);
const vec2 s2 = vec2( .5, .5);
const vec2 s3 = vec2( .5,-.5);
const vec2 s4 = vec2(-.5,-.5);

out vec2 fsUL;
out vec2 fsUR;
out vec2 fsLL;
out vec2 fsLR;

void main()
{
    ivec2 textureSize2d;
    textureSize2d=textureSize(inputTex);
    gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0);
    vec2 fsTexture = vsTexture*vec2(textureSize2d);
    fsUL = fsTexture+s1;
    fsUR = fsTexture+s2;
    fsLL = fsTexture+s3;
    fsLR = fsTexture+s4;
}
