#version 330

#include "transitionHelperGL.h"
#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;

uniform float transitionProgress=1.0;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform int transitionState;
uniform float baseAlpha=1.0;
uniform vec2 windowSize;
uniform vec2 uvScale;

in vec2 fsFragScale;
in vec2 fsPosScale;
in vec2 fsTexture;
in float texWidth;


const float softEdgeMaxWidth = .09;
const float edgeRamp = 0.3;


out vec4 outColor;

void main()
{
    vec4 colorB=vec4(0,0,0,0);
    vec4 colorA=vec4(0,0,0,0);
    float alpha = baseAlpha;
    if(transitionState==0)
    {
        colorA=getColor(inputTex,fsTexture);
        colorB=vec4(0,0,0,0);
    }
    else
    {
        colorB=getColor(inputTex,fsTexture);
        colorA=vec4(0,0,0,0);
    }

    float open=transitionProgressLinear*.5;
    float middle=.5;
    vec2 curPos=gl_FragCoord.xy*fsPosScale;

    if(curPos.x<middle)
    {
        curPos.x+=open;
        if(curPos.x>middle)
        {
            outColor=colorA;
        }
        else
        {
            outColor=colorB;
            float distanceFromMiddle=abs(.5-curPos.x);
            float softEdgeWidth=min(softEdgeMaxWidth,transitionProgressLinear*edgeRamp);
            if(distanceFromMiddle<softEdgeWidth)
            {
                float blend=smoothstep(0.0,.7,distanceFromMiddle/softEdgeWidth);
                mixColor(outColor, colorA, colorB, blend);
            }
        }
    }
    else
    {
        curPos.x-=open;
        if(curPos.x<middle)
        {
            outColor=colorA;
        }
        else
        {
            outColor=colorB;
            float distanceFromMiddle=abs(.5-curPos.x);
            float softEdgeWidth=min(softEdgeMaxWidth,transitionProgressLinear*edgeRamp);
            if(distanceFromMiddle<softEdgeWidth)
            {
                float blend=smoothstep(0.0,.7,distanceFromMiddle/softEdgeWidth);
                mixColor(outColor, colorA, colorB, blend);
            }
        }
    }

#ifdef USE_MASK
    alpha *= texture(maskTex, gl_FragCoord.xy * fsFragScale).a;
#endif
    multiplyOpacity(outColor, alpha);
}
