//

// Fragment shader for Two Color effect
//
// Author: Blah
//

#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;


uniform vec4 darkColor;
uniform vec4 brightColor;
uniform float uBlendValue=1.0;


in vec2 fsTexture;
in vec2 fsMaskTexture;
out vec4 outColor;

void main()
{
    vec4 texel = texture(inputTex, fsTexture);
#ifdef PRE_MULT
    divideAlpha(texel);
#endif
    // Convert to grayscale using NTSC conversion weights
    float gray = dot(texel.rgb, vec3(0.299, 0.587, 0.114));

    // linear interp between darkColor and brightColor using gray scale
    outColor.rgb=mix(darkColor.rgb,brightColor.rgb,gray);
    outColor.a=texel.a;
    float blendValue=uBlendValue;
#ifdef USE_MASK
    blendValue*=texture(maskTex,fsMaskTexture).a;
#endif
    outColor=mix(texel,outColor,blendValue);
#ifdef PRE_MULT
    multiplyAlpha(outColor);
#endif
}
