//
// Fragment shader for doing "fat" blur
//
// Author: Jeff Brown
//
//


#version 330

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;

uniform float blurAmount;
uniform float uPass;
uniform float uBlendValue=1.0;

in vec2 fsTexCoords[15];
in vec2 fsTexture;
in vec2 fsMaskTexture;
out vec4 outColor;

void main()
{
    vec4 texel = texture(inputTex, fsTexture);
    outColor=vec4(0.0);

    outColor += texture(inputTex, fsTexCoords[ 0]);
    outColor += texture(inputTex, fsTexCoords[ 1]);
    outColor += texture(inputTex, fsTexCoords[ 2]);
    outColor += texture(inputTex, fsTexCoords[ 3]);
    outColor += texture(inputTex, fsTexCoords[ 4]);
    outColor += texture(inputTex, fsTexCoords[ 5]);
    outColor += texture(inputTex, fsTexCoords[ 6]);
    outColor += texture(inputTex, fsTexCoords[14]);
    outColor += texture(inputTex, fsTexCoords[ 7]);
    outColor += texture(inputTex, fsTexCoords[ 8]);
    outColor += texture(inputTex, fsTexCoords[ 9]);
    outColor += texture(inputTex, fsTexCoords[10]);
    outColor += texture(inputTex, fsTexCoords[11]);
    outColor += texture(inputTex, fsTexCoords[12]);
    outColor += texture(inputTex, fsTexCoords[13]);

    outColor*=vec4(1.0/15.0,1.0/15.0,1.0/15.0,1.0/15.0);

    float blendValue=uBlendValue;
#ifdef USE_MASK
    blendValue*=texture(maskTex,fsMaskTexture).a;
#endif
    outColor = mix(texel, outColor, blendValue);
}
