#version 330

#include "transitionHelperGL.h"
#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;

uniform float transitionProgress=1.0;
uniform float transitionAlpha=1.0;
uniform int transitionState;
uniform float baseAlpha=1.0;
uniform float squareSize=1.0;
in vec2 fsMaskTexture;
uniform vec2 windowSize;

in vec2 fsTexture;
in vec2 fsTextureSize;
in vec2 fsFragScale;
in vec2 fsSquareSize;
in float fsMix;
in float fsABSelect;

out vec4 outColor;

//ivec2 size=ivec2(int(squareSize*10.0),int(squareSize*10.0));
ivec2 size=ivec2(10,10);

uniform float smoothness=1.0;

float rand (vec2 co) {
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

void main() {
    vec2 p = gl_FragCoord.xy*fsFragScale;
    float r = rand(floor(fsSquareSize * p));
    float m = smoothstep(0.0, -smoothness, r - (fsMix * (1.0 + smoothness)));

    vec4 texColor=getColor(inputTex,fsTexture);
    vec4 texelA=mix(vec4(0,0,0,0),texColor,fsABSelect);
    vec4 texelB=mix(texColor,vec4(0,0,0,0),fsABSelect);
    mixColor(outColor, texelB, texelA, m);

    float alpha = baseAlpha;
#ifdef USE_MASK
    alpha *= texture(maskTex, fsMaskTexture).a;
#endif
    multiplyOpacity(outColor, alpha);
}
