#version 330

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;

layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;

uniform float uLocalTime;
uniform float speed;

out vec2 fsTexture;
out vec2 fsMaskTexture;
out vec2 fsTextureSize;
out vec3 fsPosition;
out float cosTime1;
out float cosTime2;
out float cosTime3;
out vec2 fsTime;


void main()
{
    gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0);

    fsTexture=vsTexture;
    ivec2 texSize=textureSize(inputTex);
    fsTextureSize=vec2(texSize);
    fsPosition=vsPosition*vec3(1.0,fsTextureSize.y/fsTextureSize.x,1.0);

    fsMaskTexture=vsTexture/fsTextureSize;
    texSize=textureSize(maskTex);
    fsMaskTexture*=vec2(texSize);

    float timeValue=uLocalTime*speed;
    cosTime1=cos(timeValue*.3);
    cosTime2=cos(timeValue*.5);
    cosTime3=cos(timeValue*40.0);
    fsTime=vec2(timeValue*0.1);
}
