#version 330

#include "inputShaderHelperGL.h"
#include "alpha.h"
#include "inputColorHelper.h"

uniform sampler2DRect inputTex0;
uniform sampler2DRect inputTexMask;
uniform vec4 endColor;
uniform float endOpacity;

in vec2 fsTexture;
in vec2 fsTextureMask;
out vec4 outColor;



void main()
{
    
#ifdef ARGB
    outColor=texture(inputTex0, fsTexture).argb;
#endif
    
#ifdef ABGR
    outColor=texture(inputTex0, fsTexture).abgr;
#endif

#ifdef BGRA
    outColor=texture(inputTex0, fsTexture).bgra;
#endif
    
#ifdef RGBA
    outColor=texture(inputTex0, fsTexture).rgba;
#endif

    outColor=processColorProfile(outColor);

#ifdef USE_MASK
    multiplyOpacity(outColor, texture(inputTexMask, fsTextureMask).a);
#endif

#ifdef USE_END_COLOR
    mixColor(outColor, endColor, outColor, endOpacity);
#endif

}
