#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
layout (location=2) in vec2 vsTextureMask;
layout (location=3) in vec2 vsTexture2;

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;

uniform int transitionState;
uniform float transitionProgress=1.0;
uniform mat4 worldViewProj;

out vec2 fsTexture;
out vec2 fsTexture2;
out vec2 fsTextureSize;
out vec2 fsTextureSize2;
out vec2 fsTextureNormalized;
out vec2 fsTextureNormalized2;
out vec2 fsMaskTexture;
out float fsMix;
out float fsABSelect;

void main()
{
    gl_Position=vec4(vsPosition,1.0)*worldViewProj;

    ivec2 texSize=textureSize(inputTex);
    fsTextureSize=vec2(texSize);
    fsTexture = vsTexture*vec2(texSize);
    fsMaskTexture=vsTextureMask*vec2(textureSize(maskTex));
    fsTextureNormalized=vsTexture;

    fsABSelect=1.0;
    if(transitionState==2)
        fsABSelect=0.0;

    if(transitionProgress<=.5)
        fsMix=transitionProgress*2.;
    else
        fsMix=(1.-transitionProgress)*2.;

    vec2 tmp=fsTexture/fsTextureSize;
    texSize=textureSize(inputTex1);
    fsTextureSize2=vec2(texSize);
    fsTexture2 = vsTexture2*vec2(texSize);
    fsTextureNormalized2=vsTexture2;
}
