#version 330

#include "transitionHelperGL.h"
#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;

uniform float transitionProgress=1.0;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;
uniform vec4 burnColor;
uniform int transitionState;

in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsTextureSize;
in vec2 fsTextureSize2;
in vec2 fsMaskTexture;
in vec2 fsTextureNormalized;
in vec2 fsTextureNormalized2;
in float fsMix;

out vec4 outColor;

const vec2 center = vec2(0.5, 0.5);

float quadraticInOut(float t)
{
    float p = 2.0 * t * t;
    return t < 0.5 ? p : -p + (4.0 * t) - 1.0;
}

// Custom parameters
uniform float size=.04;
uniform float zoom=20.;
uniform float colorSeparation=0.82;

void main()
{
    vec2 p = fsTextureNormalized;
    vec2 p2=fsTextureNormalized2;

    float inv = 1. - transitionProgressLinear;
    vec2 disp = size*vec2(cos(zoom*p.x), sin(zoom*p.y));
    vec2 disp2=size*vec2(cos(zoom*p2.x), sin(zoom*p2.y));

    //    vec4 colorIn=texture(inputTex,(p+inv*disp)*fsTextureSize);
    //
    //    float progress=transitionProgressLinear;
    //    vec4 colorOut;
    //
    //    colorOut.r=texture(inputTex1,(p2+progress*disp2*(1.0-colorSeparation))*fsTextureSize2).r;
    //    colorOut.ga=texture(inputTex1,(p2+progress*disp2)*fsTextureSize2).ga;
    //    colorOut.b=texture(inputTex1,(p2+progress*disp2*(1.0+colorSeparation))*fsTextureSize2).b;
    //
    //    outColor=mix(colorOut,colorIn,transitionProgress);

    float progress = transitionProgressLinear;
    float alpha = 1.0;
    if(transitionState==0)
    {
        outColor=texture(inputTex,(p+inv*disp)*fsTextureSize);
        alpha *= progress;
    }
    else
    {
        outColor.r=getColor(inputTex,(p+progress*disp*(1.0-colorSeparation))*fsTextureSize).r;
        outColor.ga=getColor(inputTex,(p+progress*disp)*fsTextureSize).ga;
        outColor.b=getColor(inputTex,(p+progress*disp*(1.0+colorSeparation))*fsTextureSize).b;
        alpha *= inv;
    }

    alpha *= baseAlpha;

#ifdef USE_MASK
    alpha *= texture(maskTex, fsMaskTexture).a;
#endif

    multiplyOpacity(outColor, alpha);
}
