
#include "metalShaderTypes.h"
#include "alpha.h"

typedef struct
{
    float4 burnColor;
} fxVars;


vertex vertexOut vertexFunc(uint vertexID [[ vertex_id ]],const device txShaderVers* in[[ buffer(0) ]],constant txShaderUniforms& uniforms[[ buffer(3) ]],constant fxVars& vars[[ buffer(2)]])
{
    vertexOut out;

    out.position=in[vertexID].pos*uniforms.worldViewProj;

    out.tex1=in[vertexID].tex1;
    out.tex2=in[vertexID].tex2;
    out.texMask=in[vertexID].texMask;
    out.normPos=in[vertexID].pos.xy*vec2(.5,.5f)+vec2(.5,.5);
    return out;
}

fragment float4 fragmentFunc(vertexOut input [[stage_in]]
                             ,texture2d<half> inputTex0 [[ texture(0) ]]
                             ,texture2d<half> inputTex1 [[ texture(1) ]]
                             ,texture2d<half> inputTexMask [[ texture(2) ]]
                             ,constant txShaderUniforms& u[[ buffer(2) ]]
                             ,constant subFXVars& subVars[[buffer(3)]]
                             ,constant fxVars& vars[[ buffer(1)]])
{
    float rad = 1.3 * u.transitionProgress; // radius from center of the uv texture square
    float swell = 0.5432* u.transitionProgress; // swell region magnitude
    vec2 CPoint = vec2(0.5, 0.5); // center point
    float dist = length((input.tex1 - CPoint)/vec2(0.70,1));
    vec2 uvOrig = input.tex1;
    vec2 uvNew = uvOrig;
    float alpha = 0; // blend factor between the 2 textures
    if (dist < rad) // show the new texture - this expands from center outwards
    {
        alpha = 1; //when inside, show the new texture colour
    }
    if (dist > rad && dist < (rad + swell))
    {
        float lambda = smoothstep(rad, rad+swell, dist); // factor in [0,1]
        alpha = 1 - lambda; // modified blend factor
        vec2 vec = (uvOrig - CPoint) ;
        vec2 dir = ((vec)/(length(vec/vec2(0.70,1)))) ;
        uvNew = CPoint + ((1-lambda) * rad + lambda * (rad+swell)) * dir;
    }
    if (dist >= rad + swell)
        alpha = 0; // show the old texture only

    vec4 texColor=getColor(inputTex0,uvNew);
    vec4 colorA=mix(vec4(0,0,0,0),texColor,1.0-u.mix);
    vec4 colorB=mix(texColor,vec4(0,0,0,0),1.0-u.mix);
    float4 outColor;
    mixColor(outColor, colorA, colorB, alpha);

    alpha = u.baseAlpha;
#ifdef USE_MASK
    alpha *= float(inputTexMask.sample(linearSampler, input.texMask).a);
#endif
    multiplyOpacity(outColor, alpha);

    return outColor;
}
