#include "metalShaderTypes.h"
#include "commonMLDX.h"
#include "alpha.h"
#include "outputColorHelper.h"

constexpr sampler nearestSampler(
    mip_filter::nearest,
    mag_filter::nearest,
    min_filter::nearest,
    address::clamp_to_border,
    border_color::transparent_black);

vertex pixCopyVertexOut vertexFunc(uint vertexID [[ vertex_id ]],
                                   const device pixCopyVertexFormat* in [[ buffer(0) ]])
{
    pixCopyVertexOut out;
    out.position = in[vertexID].pos;
    out.texCoord = in[vertexID].tc;
    return out;
}

fragment float4 fragmentFunc(pixCopyVertexOut input [[stage_in]],
                             texture2d<half> inputTex0 [[ texture(0) ]])
{
    float2 texSize = float2(inputTex0.get_width(), inputTex0.get_height());
    float4 outColor = float4(inputTex0.sample(nearestSampler, input.texCoord/texSize));
    outColor = toOutput(outColor);
    return outColor;
}
