#version 330

#include "transitionHelperGL.h"
#include "kaleidoscopeHelper.h"
#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;
uniform float transitionProgress=1.0;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;
uniform vec4 burnColor;

in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsTextureSize;
in vec2 fsTextureSize2;
in vec2 fsMaskTexture;
in vec2 fsTextureNormalized;
in vec2 fsTextureNormalized2;
in float fsMix;

out vec4 outColor;

uniform float speed=1.;
uniform float angle=2.;
uniform float power=2.;

void main()
{
    vec2 p = fsTextureNormalized;
    vec2 p2 = fsTextureNormalized2;
    kaleidoscopeTransform(p, transitionProgressLinear, power, speed);

    vec4 colorA = getColor(inputTex, fsTexture);
    vec4 colorB = getColor(inputTex1, fsTexture2);
    vec4 colorA2 = getColor(inputTex, p * fsTextureSize);
    vec4 colorB2 = getColor(inputTex1, p2 * fsTextureSize2);

#ifndef PRE_MULT
    multiplyAlpha(colorA);
    multiplyAlpha(colorB);
    multiplyAlpha(colorA2);
    multiplyAlpha(colorB2);
#endif

    colorA = mix(colorA, colorA2, 1.0 - 2.0*abs(transitionProgressLinear - 0.5));
    colorB = mix(colorB, colorB2, 1.0 - 2.0*abs(transitionProgressLinear - 0.5));
    outColor = mix(colorB, colorA, transitionProgressLinear);

#ifdef USE_MASK
    multiplyOpacityPremultiplied(outColor, texture(maskTex, fsMaskTexture).a);
#endif

#ifndef PRE_MULT
    divideAlpha(outColor);
#endif
}
