#version 330

layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture;
layout (location=2) in vec2 vsTextureMask;

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;
uniform mat4 worldViewProj;
uniform int transitionState;

out vec2 fsTexture;
out vec2 fsMaskTexture;
out float fsMix;

void main()
{
    gl_Position = vec4(vsPosition, 1.0) * worldViewProj;
    fsTexture = vsTexture * vec2(textureSize(inputTex));
    fsMaskTexture = vsTextureMask * vec2(textureSize(maskTex));
    fsMix = transitionState == 2 ? 0.0 : 1.0;
}
