#include "commonMLDX.h"
#include "alpha.h"
#include "inputShaderHelper.h"
#include "inputColorHelper.h"


fragment float4 fragmentFunc(inputVertexType input [[stage_in]]
                                 ,texture2d<half> inputTex0 [[ texture(0) ]]
                                 ,texture2d<half> inputTex1 [[ texture(1) ]]
                                 ,texture2d<half> inputTex2 [[ texture(2) ]]
                                 ,texture2d<half> inputTex3 [[ texture(3) ]]
                                 ,texture2d<half> maskTex [[ texture(4) ]]
                                 ,constant planarUniforms& uniforms[[ buffer(0) ]]
)
{
    
#ifdef ARGB
    float4 outColor=textureFetchNearest(inputTex0, input.texCoordY).argb;
#endif
    
#ifdef ABGR
    float4 outColor=textureFetchNearest(inputTex0, input.texCoordY).abgr;
#endif

#ifdef BGRA
    float4 outColor=textureFetchNearest(inputTex0, input.texCoordY).bgra;
#endif
    
#ifdef RGBA
    float4 outColor=textureFetchNearest(inputTex0, input.texCoordY).rgba;
#endif

    outColor=processColorProfile(outColor);

#ifdef USE_MASK
    multiplyOpacity(outColor, textureFetchNearest(maskTex, input.maskCoord).a);
#endif

#ifdef USE_END_COLOR
    mixColor(outColor, uniforms.endColor, outColor, uniforms.endOpacity);
#endif

    return outColor;
}
