//
// invert like a color negative
// updated to 330 and rvfx system by Jeff Brown
//


#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect maskTex;
uniform float uBlendValue=1.0;

in vec2 fsTexture;
in vec2 fsMaskTexture;
out vec4 outColor;


void main()
{
    vec4 texel = texture(inputTex, fsTexture);
#ifdef PRE_MULT
    divideAlpha(texel);
#endif
    // invert color components
    outColor.rgb = 1.0 - texel.rgb;
    float blendValue=uBlendValue;
#ifdef USE_MASK
    blendValue*=texture(maskTex,fsMaskTexture).a;
#endif
    outColor.rgb=mix(texel.rgb,outColor.rgb,blendValue);
    outColor.a=texel.a;
#ifdef PRE_MULT
    multiplyAlpha(outColor);
#endif
}

