uniform vec2 uvOffset;
uniform vec2 uvScale;

vec4 backgroundEffect(sampler2DRect objectTexture,
                      vec2 objectTextureCoordinates,
                      sampler2DRect blurredBackgroundTexture,
                      sampler2DRect backgroundTexture,
                      vec2 screenPosition)
{
    vec4 objectColor=texture(objectTexture,objectTextureCoordinates);
    vec2 screenCoord=screenPosition*uvScale+uvOffset;

    vec4 backgroundColor=texture(backgroundTexture,screenCoord);
    vec4 invertedBackgroundColor=vec4(1.0);
    invertedBackgroundColor.rgb-=backgroundColor.rgb;

    vec4 outColor=mix(invertedBackgroundColor,backgroundColor,1.0-objectColor.a);

    outColor*=objectColor.a;

    return outColor;
}
