#version 330

#include "transitionHelperGL.h"
#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;

uniform float transitionProgress=1.0;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;
uniform vec4 burnColor;

in vec2 fsTexture;
in vec2 fsTextureSize;
in vec2 fsMaskTexture;
in vec2 fsTextureNormalized;
in float fsABSelect;

out vec4 outColor;

void main(void)
{
    vec2 p = fsTextureNormalized;

    float T = transitionProgress;

    float S0 = 1.0;
    float S1 = 250.0;
    float S2 = 1.0;

    // 2 segments, 1/2 each
    float Half = 0.5;

    float PixelSize = ( T < Half ) ? mix( S0, S1, T / Half ) : mix( S1, S2, (T-Half) / Half );

    vec2 D = PixelSize / fsTextureSize.xy;

    // remap UV from 0...1 to -0.5...+0.5 to make the mosaic pattern converge torwards the image center
    vec2 UV = ( p + vec2( -0.5 ) ) / D;

    // don't forget to remap coords back to 0...1 after ceil()
    vec2 Coord = clamp( D * ( ceil( UV + vec2( -0.5 ) ) ) + vec2( 0.5 ), vec2( 0.0 ), vec2( 1.0 ) );

    vec4 texColor=getColor(inputTex,Coord*fsTextureSize);

    vec4 colorA=mix(vec4(0,0,0,0),texColor,fsABSelect);
    vec4 colorB=mix(texColor,vec4(0,0,0,0),fsABSelect);
    mixColor(outColor, colorB, colorA, transitionProgressLinear);

    float alpha = baseAlpha;
#ifdef USE_MASK
    alpha *= texture(maskTex, fsMaskTexture).a;
#endif
    multiplyOpacity(outColor, alpha);
}
