#version 330

#include "transitionHelperGL.h"
#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;

uniform float transitionProgress=1.0;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform int transitionState;
uniform float baseAlpha=1.0;
uniform vec2 windowSize;
uniform vec2 uvScale;

in vec2 fsFragScale;
in vec2 fsPosScale;
in vec2 fsTexture;
in vec2 fsTexture2;
in float texWidth;


const float softEdgeMaxWidth = .09;
const float edgeRamp = 0.3;


out vec4 outColor;

void main()
{
    vec4 colorB=getColor(inputTex1,fsTexture2);
    vec4 colorA=getColor(inputTex,fsTexture);
    float alpha = baseAlpha;
    vec2 tadj=gl_FragCoord.xy*fsPosScale;
    float open=transitionProgressLinear*.5;
    float middle=.5;
    if(tadj.x<middle)
    {
        tadj.x+=open;
        if(tadj.x>middle)
        {
            outColor=colorA;
        }
        else
        {
            outColor=colorB;
            float distanceFromMiddle=abs(.5-tadj.x);
            float softEdgeWidth=min(softEdgeMaxWidth,transitionProgressLinear*edgeRamp);
            if(distanceFromMiddle<softEdgeWidth)
            {
                float blend=smoothstep(0.0,.7,distanceFromMiddle/softEdgeWidth);
                mixColor(outColor, colorA, colorB, blend);
            }
        }
    }
    else
    {
        tadj.x-=open;
        if(tadj.x<middle)
        {
            outColor=colorA;
        }
        else
        {
            outColor=colorB;
            float distanceFromMiddle=abs(.5-tadj.x);
            float softEdgeWidth=min(softEdgeMaxWidth,transitionProgressLinear*edgeRamp);
            if(distanceFromMiddle<softEdgeWidth)
            {
                float blend=smoothstep(0.0,.7,distanceFromMiddle/softEdgeWidth);
                mixColor(outColor, colorA, colorB, blend);
            }
        }
    }

#ifdef USE_MASK
    alpha *= texture(maskTex, gl_FragCoord.xy * fsFragScale).a;
#endif
    multiplyOpacity(outColor, alpha);
}
