#include "metalShaderTypes.h"
#include "alpha.h"

typedef struct
{
    vector_float4 pos;
    packed_float2 tc;
} vsPT;

typedef struct
{
    float4 pos [[position]];
    float2 tc0;
#ifndef HQ
    float2 tc1;
    float2 tc2;
    float2 tc3;
#endif
} fsPT;

vertex fsPT vertexFunc(uint vertexID [[vertex_id]], const device vsPT *input [[buffer(0)]])
{
    fsPT output;
    output.pos = input[vertexID].pos;
    output.pos.y *= -1.0;
#ifdef HQ
    output.tc0 = input[vertexID].tc;
#else
    output.tc0 = input[vertexID].tc + float2(-0.5, 0.5);
    output.tc1 = input[vertexID].tc + float2(0.5, 0.5);
    output.tc2 = input[vertexID].tc + float2(0.5, -0.5);
    output.tc3 = input[vertexID].tc + float2(-0.5, -0.5);
#endif
    return output;
}

fragment float4 fragmentFunc(fsPT input [[stage_in]], texture2d<half> baseMap [[texture(0)]])
{
    float2 texSize = float2(baseMap.get_width(), baseMap.get_height());
    float4 outColor = float4(baseMap.sample(linearSampler, input.tc0.xy / texSize));
#ifndef HQ
    outColor += float4(baseMap.sample(linearSampler, input.tc1.xy / texSize));
    outColor += float4(baseMap.sample(linearSampler, input.tc2.xy / texSize));
    outColor += float4(baseMap.sample(linearSampler, input.tc3.xy / texSize));
    outColor *= 0.25;
#endif
    processAlpha(outColor)
    return outColor.bgra;
}
