#version 330


layout (location=0) in vec3 vsPosition;
layout (location=1) in vec2 vsTexture1;
layout (location=2) in vec2 vsTextureMask;
layout (location=3) in vec2 vsTexture2;

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;

out vec2 fsMaskTexture;
out vec2 fsTexture1;
out vec2 fsTexture2;
out vec2 fsTexture2Normalized;

void main()
{
    gl_Position=vec4(vsPosition.x,vsPosition.y,vsPosition.z,1.0);

    ivec2 texSize=textureSize(inputTex);
    fsTexture1 = vsTexture1 * vec2(texSize);
    fsTexture2Normalized = vsTexture2;
    texSize=textureSize(inputTex1);
    fsTexture2 = vsTexture2*vec2(texSize);
    texSize=textureSize(maskTex);
    fsMaskTexture=vsTextureMask*vec2(texSize);
}
