#include "metalShaderTypes.h"
#include "alpha.h"

typedef struct
{
    float4 srcColor;
    float tolerance;
} fxVars;

constant float4 toXYZ_R = float4(0.4124, 0.3576, 0.1805, 0.0);
constant float4 toXYZ_G = float4(0.2126, 0.7152, 0.0722, 0.0);
constant float4 toXYZ_B = float4(0.0193, 0.1192, 0.9505, 0.0);

vertex fxVertexOut vertexFunc(uint vertexID [[ vertex_id ]]
                              ,const device fxShaderVerts* in[[ buffer(0) ]]
                              ,texture2d<half> inputTex0 [[ texture(0) ]]
                              ,texture2d<half> inputTexMask [[ texture(1) ]]
                              ,constant fxGeneralUniforms& u[[ buffer(1) ]]
                              ,constant fxVars& vars[[ buffer(2)]])
{
    fxVertexOut out;

    out.normPos=in[vertexID].pos.xy*vec2(.5,.5f)+vec2(.5,.5);
    out.position=in[vertexID].pos;

    out.tex1=in[vertexID].tex1;
    out.texMask=in[vertexID].texMask;
    out.texSize=float2(inputTex0.get_width(),inputTex0.get_height());
    return out;
}

fragment float4 fragmentFunc(fxVertexOut input [[stage_in]]
                             ,texture2d<half> inputTex [[ texture(0) ]]
                             ,texture2d<half> inputTexMask [[ texture(1) ]]
                             ,constant fxGeneralUniforms& u[[ buffer(0) ]]
                             ,constant fxVars& vars[[ buffer(1)]])
{
    vec4 texColor = getColor(inputTex, fsTexture);
#ifdef PRE_MULT
    divideAlpha(texColor);
#endif

#ifdef LINEAR_16
    float4 srcColor = float4(dot(toXYZ_R, vars.srcColor), dot(toXYZ_G, vars.srcColor), dot(toXYZ_B, vars.srcColor), 1.0);
#else
    float4 srcColor = vars.srcColor;
#endif


    float4 outColor=texColor;
    vec3 diff=abs(texColor.rgb / u.nitsScale - srcColor.rgb);
    if(diff.r<vars.tolerance)
    {
        if(diff.g<vars.tolerance)
        {
            if(diff.b<vars.tolerance)
            {
                outColor.a *= 1.0 - u.blendValue;
            }
        }
    }

    float blendValue=u.blendValue;
#ifdef USE_MASK
    blendValue*=getColor(inputTexMask,input.texMask).a;
#endif
    outColor.rgb = mix(texColor.rgb, outColor.rgb, blendValue);
#ifdef PRE_MULT
    multiplyAlpha(outColor);
#endif
    return outColor;
}
