#version 330

#include "alpha.h"

uniform sampler2DRect inputTex;
uniform sampler2DRect inputTex1;
uniform sampler2DRect maskTex;
uniform float transitionProgress=1.0;
uniform float transitionProgressLinear=1.0;
uniform float transitionAlpha=1.0;
uniform float baseAlpha=1.0;
uniform vec4 burnColor;

in vec2 fsTexture;
in vec2 fsTexture2;
in vec2 fsTextureSize;
in vec2 fsTextureSize2;
in vec2 fsMaskTexture;
in vec2 fsTextureNormalized;
in vec2 fsTextureNormalized2;

out vec4 outColor;


void main()
{
    float x1 = transitionProgressLinear;
    vec2 p1 = fsTextureNormalized;
    vec2 p2 = fsTextureNormalized2;

    float x2=smoothstep(.20,.80,(x1*2.0+p1.x-1.0));
    x1=smoothstep(.20,.80,(x1*2.0+p1.x-1.0));

    vec2 tc1=(p1-.5)*(1.-x1)+.5;
    vec2 tc2=(p2-.5)*(1.-x2)+.5;

    tc1=(p1-.5)*x1+.5;
    // tc2=(p2-.5)*x2+.5;

    vec4 colorA=texture(inputTex,tc1*fsTextureSize);
    vec4 colorB=texture(inputTex1,tc2*fsTextureSize2);
    mixColor(outColor, colorB, colorA, transitionProgressLinear);

#ifdef USE_MASK
    multiplyOpacity(outColor, texture(maskTex, fsMaskTexture).a);
#endif
}
