// Convert (and horizontal downsample) RGB to YUV2 using std 601 (this seems to be what Blackmagic card likes)
#version 330

uniform sampler2DRect inputTexOdd;
uniform sampler2DRect inputTexEven;

const vec4 std709X = vec4(  0.183,   0.614,  0.062, 0.0  );
const vec4 std709Y = vec4( -0.101,  -0.338,  0.439, 0.0  );
const vec4 std709Z = vec4(  0.439,  -0.399, -0.040, 0.0  );

in vec2 fsTex0;
in vec2 fsTex1;

out vec4 outColor;

void main()
{
    vec4 texColor0;
    vec4 texColor1;
    vec4 texColor01;
    vec4 texColor11;
    vec4 yuv0;
    vec4 yuv1;
    
    float isOddLine=floor(fract(fsTex0.y * 0.5) * 2.0);

    texColor0 = texture(inputTexOdd, fsTex0);
    texColor1 = texture(inputTexOdd, fsTex1);

    texColor01 = texture(inputTexEven, fsTex0);
    texColor11 = texture(inputTexEven, fsTex1);

    texColor0=mix(texColor01,texColor0,isOddLine);
    texColor1=mix(texColor11,texColor1,isOddLine);

    yuv0 = vec4(dot(std709X, texColor0)+0.0625,
                dot(std709Y, texColor0)+0.5,
                dot(std709Z, texColor0)+0.5,
                1.0 );

    yuv1 = vec4(dot(std709X, texColor1)+0.0625,
                dot(std709Y, texColor1)+0.5,
                dot(std709Z, texColor1)+0.5,
                1.0 );


    outColor.a = yuv1.r;
    outColor.r = (yuv0.b+yuv1.b)*.5;
    outColor.b = (yuv0.g+yuv1.g)*.5;
    outColor.g = yuv0.r;
}


